package com.penpower.idcamerademo;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.penpower.camera.Camera;
import com.penpower.camera.Define;
import com.penpower.camera.RectMaskImageView;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class CameraActivity extends Camera {

    private TextView mCancelButton;
    private TextView mShutterButton;
    private CountDownTimer mCountDownTimer;

    private String mCameraMode = MainActivity.CAMERA_SIDE.CARD_NONE;
    private boolean mIsTurnOn = false;
    private boolean mIsInit = true;
    private boolean mIsSupportFlash = false;
    private boolean mIsRetake = true;
    private Paint mSemiBlackPaint;

    @Override
    public void onCreate(Bundle aBundle) {
        /*
         * 設定的參數必須要super.onCreate()前面才會生效。
         */
        Bundle getInfo = getIntent().getExtras();
        if (getInfo != null) {
            Define.CustomAPI.mSignature = getInfo.getString(Define.CustomParameter.SIGNATURE, "");
            Define.CustomAPI.mStorePath = getInfo.getString(Define.CustomParameter.STORE_PATH, ""); // 圖片圖存路徑
            mCameraMode = getInfo.getString(MainActivity.CAMERA_MODE, MainActivity.CAMERA_SIDE.CARD_NONE);
            Define.CustomAPI.mIsFrontCamera = getInfo.getBoolean(MainActivity.IS_FRONT_CAMERA, false);
        }
        Define.CustomAPI.mRectMaskColor = getResources().getColor(R.color.ap_camera_background);
        Define.CustomAPI.mMaskColor = getResources().getColor(R.color.transparent); // 中間四周的背景遮罩顏色

        Define.CustomAPI.mDetectionLineColor = getResources().getColor(R.color.ap_detection_line_color); // 畫偵測ID CARD的邊線顏色
        Define.CustomAPI.mToolBarColor = getResources().getColor(R.color.ap_toolbar_bg); // 設定右邊Toolbar的顏色，因螢幕寬高與Preview Size寬高比不一致時會出現區塊。
        Define.CustomAPI.mBackgroundColor = getResources().getColor(R.color.ap_camera_background); // Mask背景色，可設定為背景色
        Define.CustomAPI.mMaskRoundX = 50; // Mask圓角
        Define.CustomAPI.mMaskRoundY = 50; // Mask圓角

        setDetectionTimes(1); // 滿足偵測次數後，直接拍照。
        setImageBlurredTimes(1); // 滿足模糊判斷後，執行自動對焦。
        setPlaySound(false); // 關閉拍照聲音。
        setPlayFocusSound(false); // 關閉對焦聲音，預設關閉。

        Point size = new Point();
        getWindowManager().getDefaultDisplay().getSize(size);
        int measuredWidth = size.x;
        int measuredHeight = size.y;
        int previewWidth = (int)(measuredWidth - 2*getResources().getDimension(R.dimen.camera_button_width) - getResources().getDimension(R.dimen.camera_button_width));
        int previewHeight = previewWidth*9/16; // 必須為16:9，不然會造成Preview影像變形
        previewHeight = previewHeight - (int)getResources().getDimension(R.dimen.camera_button_height);
        previewWidth = previewHeight*16/9;

        int offsetX = (measuredWidth - previewWidth)/2;
        int offsetY = (int)(measuredHeight - previewHeight - 2*getResources().getDimension(R.dimen.camera_button_height));

        Define.CustomAPI.mPreviewLeft = offsetX;
        Define.CustomAPI.mPreviewTop = offsetY;
        Define.CustomAPI.mPreviewWidth = previewWidth;

        super.onCreate(aBundle);

        RelativeLayout rootLayout = findViewById(R.id.relative_layout_bar);
        getLayoutInflater().inflate(R.layout.app_control_bar, rootLayout, true);

        initLayout();

        TextView messageView = findViewById(R.id.tv_title);
        if (messageView != null) {
            switch(mCameraMode) {
                case MainActivity.CAMERA_SIDE.CARD_FRONT:
                    setAutoCapture(true);
                    messageView.setText(R.string.btn_capture_front);
                    break;
                case MainActivity.CAMERA_SIDE.CARD_BACK:
                    setAutoCapture(true);
                    messageView.setText(R.string.btn_capture_back);
                    break;
                case MainActivity.CAMERA_SIDE.CARD_MANUALLY:
                    setAutoCapture(false);
                    break;
                default:
                    setAutoCapture(true);
                    messageView.setText(R.string.btn_capture_none);
                    break;
            }
        }
        if (Define.CustomAPI.mIsFrontCamera == false) {
            messageView.setVisibility(View.VISIBLE);
        } else {
            messageView.setVisibility(View.INVISIBLE);
        }

        switchStatus(mCameraMode);

        if (mCameraMode.compareToIgnoreCase(MainActivity.CAMERA_SIDE.CARD_MANUALLY) == 0) {
            if (mShutterButton != null) {
                mShutterButton.setVisibility(View.VISIBLE);
            }
        } else {
            mCountDownTimer = new CountDownTimer(5000, 1000) {
                @Override
                public void onTick(long millisUntilFinished) {

                }

                @Override
                public void onFinish() {
                    if (mShutterButton != null) {
                        mShutterButton.setVisibility(View.VISIBLE);
                    }
                }
            };
            if (Define.CustomAPI.mIsFrontCamera == false) {
                if (mCountDownTimer != null) {
                    mCountDownTimer.start();
                }
            }
        }

        RelativeLayout barLayout = findViewById(R.id.app_relative_layout_bar);
        if (Define.CustomAPI.mIsFrontCamera == false) {
            barLayout.addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
                @Override
                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (true) {
                        if (mIsInit == true) {
                            mIsInit = false;
                            ImageView flashView = findViewById(R.id.iv_flash_image);
                            if (flashView != null) {
                                int flashHeight = 72;
                                ViewGroup.LayoutParams flashLayoutParams = flashView.getLayoutParams();
                                flashLayoutParams.height = flashHeight;
                                flashLayoutParams.width = flashHeight;
                                flashView.setLayoutParams(flashLayoutParams);

                                flashView.setOnTouchListener(new View.OnTouchListener() {
                                    @Override
                                    public boolean onTouch(View view, MotionEvent motionEvent) {
                                        if (mIsTurnOn == true) {
                                            turnLightOff();
                                            mIsTurnOn = false;
                                            view.setBackgroundResource(R.drawable.selector_camera_flash_off);
                                        } else {
                                            turnLightOn();
                                            view.setBackgroundResource(R.drawable.selector_camera_flash_on);
                                            mIsTurnOn = true;
                                        }
                                        return false;
                                    }
                                });

                                flashView.setVisibility(View.GONE);
                                flashView.setBackgroundResource(R.drawable.selector_camera_flash_off);
                                mIsTurnOn = false;
                            }
                        } else {
                            ImageView flashView = findViewById(R.id.iv_flash_image);
                            if (flashView != null) {
                                if (mIsSupportFlash == false) {
                                    flashView.setVisibility(View.GONE);
                                } else {
                                    flashView.setVisibility(View.VISIBLE);
                                }
                            }
                        }
                    }
                }
            });
            LinearLayout barMiddleLayout = findViewById(R.id.control_bar_middle);
            if (barMiddleLayout != null) {
                barMiddleLayout.setVisibility(View.VISIBLE);
            }
        } else {
            LinearLayout barMiddleLayout = findViewById(R.id.control_bar_middle);
            if (barMiddleLayout != null) {
                barMiddleLayout.setVisibility(View.GONE);
            }
        }

        /*
         * Start : 設定邊線顏色
         */
        mSemiBlackPaint = new Paint();
        mSemiBlackPaint.setColor(Color.RED); // 設定顏色
        mSemiBlackPaint.setStrokeWidth(5); // 設定寬度

        RectMaskImageView rectMaskIV = findViewById(R.id.iv_rect_mask);
        if (rectMaskIV != null) {
            rectMaskIV.setPaint(mSemiBlackPaint);
        }
        /*
         * End : 設定邊線顏色
         */
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mCountDownTimer != null) {
            mCountDownTimer.cancel();
        }
    }

    private void initLayout() {
        mShutterButton = findViewById(R.id.btn_camera_shutter);
        if (mShutterButton != null) {
            mShutterButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View aView) {
                    if (mIsRetake == false) {
                        mIsRetake = true;
                        startPreview();
                        mShutterButton.setText(getResources().getString(R.string.button_capture));
                        mCancelButton.setText(getResources().getString(R.string.button_cancel));
                    } else {
                        doCapture(); // 手動拍照
                    }
                }
            });
        }

        mCancelButton = findViewById(R.id.btn_camera_cancel);
        if (mCancelButton != null) {
            mCancelButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View aView) {
                    if (mCountDownTimer != null) {
                        mCountDownTimer.cancel();
                    }
                    finishCamera(true, null, null);
                }
            });
        }
    }

    private void switchStatus(String aCameraMode) {
        if (Define.CustomAPI.mIsFrontCamera == false) {
            if (aCameraMode.compareToIgnoreCase(MainActivity.CAMERA_SIDE.CARD_FRONT) == 0) {
                super.setOperateStatus(Define.STATUS.CARD_FRONT); // 偵測正面
            } else if (aCameraMode.compareToIgnoreCase(MainActivity.CAMERA_SIDE.CARD_BACK) == 0) {
                super.setOperateStatus(Define.STATUS.CARD_BACK); // 偵測背面
            } else {
                super.setOperateStatus(Define.STATUS.CARD_NONE); // 不偵測正反面
            }

            if (mCancelButton != null) {
                mCancelButton.setVisibility(View.VISIBLE);
            }
            if (mShutterButton != null) {
                mShutterButton.setVisibility(View.INVISIBLE);
            }
        } else {
            if (mCancelButton != null) {
                mCancelButton.setVisibility(View.VISIBLE);
            }
            if (mShutterButton != null) {
                mShutterButton.setVisibility(View.VISIBLE);
            }
        }
    }

    @Override
    public void onDetectCardStatus(int aStatus, String aMessage) {
        switch(aStatus) {
            case Define.DetectCode.SUCCESS:
                break;
            case Define.DetectCode.NOT_LICENSE:
                break;
            case Define.DetectCode.IMAGE_SMALL:
                break;
            case Define.DetectCode.IMAGE_BLURRED: {
                Paint linePaint = new Paint();
                linePaint.setColor(0xFF0000FF);
                linePaint.setStyle(Paint.Style.STROKE);
                linePaint.setStrokeWidth(5);
                setDetectionLinePaint(linePaint);

                if (mSemiBlackPaint == null) {
                    mSemiBlackPaint = new Paint();
                }
                mSemiBlackPaint.setColor(0xFF0000FF);
                mSemiBlackPaint.setStrokeWidth(4);
                RectMaskImageView rectMaskIV = findViewById(R.id.iv_rect_mask);
                if (rectMaskIV != null) {
                    rectMaskIV.setPaint(mSemiBlackPaint);
                }
                break;
            }
            case Define.DetectCode.IMAGE_REFLECTION: {
                Paint linePaint = new Paint();
                linePaint.setColor(0xFFFF0000);
                linePaint.setStyle(Paint.Style.STROKE);
                linePaint.setStrokeWidth(5);
                setDetectionLinePaint(linePaint);

                if (mSemiBlackPaint == null) {
                    mSemiBlackPaint = new Paint();
                }
                mSemiBlackPaint.setColor(0xFFFF0000);
                mSemiBlackPaint.setStrokeWidth(5);
                RectMaskImageView rectMaskIV = findViewById(R.id.iv_rect_mask);
                if (rectMaskIV != null) {
                    rectMaskIV.setPaint(mSemiBlackPaint);
                }
                break;
            }
            case Define.DetectCode.TURN_CARD_FRONT:
                break;
            case Define.DetectCode.TURN_CARD_BACK:
                break;
            case Define.DetectCode.READY_CAPTURE:{
                Paint linePaint = new Paint();
                linePaint.setColor(0xFF00FF00);
                linePaint.setStyle(Paint.Style.STROKE);
                linePaint.setStrokeWidth(5);
                setDetectionLinePaint(linePaint);

                if (mSemiBlackPaint == null) {
                    mSemiBlackPaint = new Paint();
                }
                mSemiBlackPaint.setColor(0xFF00FF00);
                mSemiBlackPaint.setStrokeWidth(2);
                RectMaskImageView rectMaskIV = findViewById(R.id.iv_rect_mask);
                if (rectMaskIV != null) {
                    rectMaskIV.setPaint(mSemiBlackPaint);
                }
                break;
            }
            case Define.DetectCode.DO_CAPTURE:
                break;
            case Define.DetectCode.FINISH_CAPTURE:
                break;
            case Define.DetectCode.IMAGE_FAILED:
                Log.i("Hank20211006", "IMAGE_FAILED");
                setDetectionLinePaint(null);
                break;
            default:
                break;
        }

        TextView messageView = findViewById(R.id.tv_message);
        if (messageView != null) {
            messageView.setText(aMessage);
            if (aMessage == null || aMessage.length() == 0) {
                messageView.setVisibility(View.INVISIBLE);
            } else {
                messageView.setVisibility(View.VISIBLE);
                if (Define.CustomAPI.mIsFrontCamera == false) {
                    messageView.setVisibility(View.VISIBLE);
                } else {
                    messageView.setVisibility(View.INVISIBLE);
                }
            }
        }
    }

    @Override
    public void isSupportFlash(boolean aIsSupport) {
        mIsSupportFlash = aIsSupport;
    }

    @Override
    public void captureResult(int aStatus, byte[] aCardJpeg, byte[] aPhotoJpeg) {
        switch(aStatus) {
            case Define.ResultCode.SUCCESS:
                // todo: Preview Image時，自定義Flag控制狀態，避免背景還正進行偵測的影像覆蓋。
                if (mIsRetake == true) {
                    if (aCardJpeg != null && aCardJpeg.length > 0) {
                        MainActivity.mCardJpeg = aCardJpeg;
                    }
                    if (aPhotoJpeg != null && aPhotoJpeg.length > 0) {
                        MainActivity.mPhotoJpeg = aPhotoJpeg;
                    }
                    stopPreview(); // 暫停拍攝 對應API為startPreview()開始拍攝
//                    if (aCardJpeg != null && aPhotoJpeg != null) {
//                        Log.i("Hank20210716", "aCardJpeg=" + aCardJpeg.length);
//                        Log.i("Hank20210716", "aPhotoJpeg=" + aPhotoJpeg.length);
//
//                        saveBitmapToFile(aCardJpeg, "/storage/emulated/0/card_clip.jpg");
//                        saveBitmapToFile(aPhotoJpeg, "/storage/emulated/0/card_org.jpg");
//                    }
                    mIsRetake = false;

                    mShutterButton.setText(getResources().getString(R.string.button_retry));
                    mCancelButton.setText(getResources().getString(R.string.button_done));

                    Message msg = new Message();
                    msg.what = 0;
                    mCameraHandler.sendMessage(msg);
                }
                break;
        }
    }

    private Handler mCameraHandler = new Handler() {
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                TextView messageView = findViewById(R.id.tv_message);
                if (messageView != null) {
                    messageView.setVisibility(View.INVISIBLE);
                }

                Paint linePaint = new Paint();
                linePaint.setColor(0xFF00FF00);
                linePaint.setStyle(Paint.Style.STROKE);
                linePaint.setStrokeWidth(5);
                setDetectionLinePaint(linePaint);

                if (mSemiBlackPaint == null) {
                    mSemiBlackPaint = new Paint();
                }
                mSemiBlackPaint.setColor(0xFF00FF00);
                mSemiBlackPaint.setStrokeWidth(2);
                RectMaskImageView rectMaskIV = findViewById(R.id.iv_rect_mask);
                if (rectMaskIV != null) {
                    rectMaskIV.setPaint(mSemiBlackPaint);
                }

                if (mShutterButton != null) {
                    mShutterButton.setVisibility(View.VISIBLE);
                }
            }
            super.handleMessage(msg);
        }
    };

    public static void saveBitmapToFile(byte[] aBitmap, String aBitmapFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(aBitmapFile);
            fos.write(aBitmap);
            fos.close();
        } catch (FileNotFoundException e) {
            Log.i("Hank20210716", "FileNotFoundException="+e.getMessage());
            e.printStackTrace();
        } catch (IOException e) {
            Log.i("Hank20210716", "IOException="+e.getMessage());
            e.printStackTrace();
        }
    }
}